#ifndef LAZY_HPP
#define LAZY_HPP
#include <vector>
#include <iostream>
#include <algorithm>
#include <random>
#include <unordered_map>
#include <unordered_set>
#include <cmath>
#include <tuple>
#include <cassert>

class lazySelect{
    public:
    int r, d, u, k, s;
    int64_t weak_cnt, strong_cnt;
    double epsilon;
    lazySelect(int r, int k, int s, double epsilon);
    bool WeakOracle(int a, int b);
    int votingselect(std::vector<int> &A, int constant);
    
    void InitWeakOracleCache(const std::vector<int>& sample);
    std::unordered_map<int, int> sample_index_map;
    std::vector<uint64_t> oracle_cache;
    std::vector<int> current_sample;

    int64_t GetWeakCnt();
    int64_t GetStrongCnt();
};
#endif